/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client;

import java.nio.file.Paths;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_702;
import potionstudios.byg.BYG;
import potionstudios.byg.BYGConstants;
import potionstudios.byg.client.gui.screen.HypogealImperiumScreen;
import potionstudios.byg.client.textures.renders.BYGParticleTypes;
import potionstudios.byg.common.container.BYGMenuTypes;
import potionstudios.byg.common.entity.boat.BYGBoatEntity;
import potionstudios.byg.common.entity.boat.BYGBoatRenderer;
import potionstudios.byg.common.particles.FallingLeafParticle;
import potionstudios.byg.common.particles.TheriumGlint;
import potionstudios.byg.mixin.access.client.MenuScreensAccess;
import potionstudios.byg.util.LangFileGenerator;

public class BYGClient {
    public static void load() {
        BYG.LOGGER.debug("BYG: \"Client Setup\" Event Starting...");
        if (BYGConstants.GENERATE_DATA) {
            LangFileGenerator.createLangFile(Paths.get("generated/en_us.json", new String[0]));
        }
        BYG.LOGGER.info("BYG: \"Client Setup\" Event Complete!");
    }

    public static void threadSafeLoad() {
        MenuScreensAccess.byg_register(BYGMenuTypes.HYPOGEAL_CONTAINER.get(), HypogealImperiumScreen::new);
    }

    public static void registerParticles(ParticleStrategy strategy) {
        strategy.register((class_2396)BYGParticleTypes.THERIUM_GLINT.get(), TheriumGlint.Provider::new);
        strategy.register((class_2396)BYGParticleTypes.WITCH_HAZEL_LEAF.get(), FallingLeafParticle.Provider::new);
        strategy.register((class_2396)BYGParticleTypes.CHERRY_BLOSSOM_FALL_WHITE.get(), FallingLeafParticle.Provider::new);
        strategy.register((class_2396)BYGParticleTypes.CHERRY_BLOSSOM_FALL_PINK.get(), FallingLeafParticle.Provider::new);
    }

    public static void registerLayerDefinitions(BiConsumer<class_5601, Supplier<class_5607>> consumer) {
        for (BYGBoatEntity.BYGType value : BYGBoatEntity.BYGType.values()) {
            consumer.accept(BYGBoatRenderer.createBoatModelName(value), class_554::method_31985);
        }
    }

    public static interface ParticleStrategy {
        public <T extends class_2394> void register(class_2396<T> var1, class_702.class_4091<T> var2);
    }
}

